const express = require('express');
const session = require('express-session');
const path = require('path');

const app = express();
const PORT = process.env.PORT || 3000;

app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));

// Session configuration
app.use(session({
  secret: 'maya-eslami-admin-secret-key',
  resave: false,
  saveUninitialized: false,
  cookie: {
    secure: false, // Set to true in production with HTTPS
    maxAge: 24 * 60 * 60 * 1000 // 24 hours
  }
}));

app.use(express.static(path.join(__dirname, 'public')));
app.use(express.urlencoded({ extended: true }));
app.use(express.json());

// Import routes and middleware
const adminRoutes = require('./routes/admin');
const adminAuth = require('./middleware/adminAuth');

app.get('/', (req, res) => {
  res.render('pages/landing');
});

app.get('/index', (req, res) => {
  res.render('pages/index');
});

app.get('/prices', (req, res) => {
  res.render('pages/prices');
});

app.get('/articles', (req, res) => {
  res.render('pages/articles');
});

app.get('/news', (req, res) => {
  res.render('pages/news');
});

app.get('/subscription', (req, res) => {
  res.render('pages/subscription');
});

app.get('/contact', (req, res) => {
  res.render('pages/contact');
});

app.get('/profile', (req, res) => {
  res.render('pages/profile');
});

app.post('/login', (req, res) => {
  res.redirect('/index');
});

app.post('/register', (req, res) => {
  res.redirect('/index');
});

// Admin routes with authentication
app.use('/admin', adminAuth, adminRoutes);

app.listen(PORT, () => {
  console.log(`Server running on http://localhost:${PORT}`);
  console.log(`Admin panel: http://localhost:${PORT}/admin/login`);
});