function toggleFaq(index) {
  const faqItems = document.querySelectorAll('.faq-content');
  const faqIcons = document.querySelectorAll('.faq-icon');

  const content = faqItems[index];
  const icon = faqIcons[index];

  if (content && icon) {
    const isHidden = content.classList.contains('hidden');

    faqItems.forEach((item, i) => {
      if (i !== index) {
        item.classList.add('hidden');
        faqIcons[i].style.transform = 'rotate(0deg)';
      }
    });

    if (isHidden) {
      content.classList.remove('hidden');
      icon.style.transform = 'rotate(180deg)';
    } else {
      content.classList.add('hidden');
      icon.style.transform = 'rotate(0deg)';
    }
  }
}

document.addEventListener('DOMContentLoaded', function() {
  const planButtons = document.querySelectorAll('.btn-primary, .btn-secondary');

  planButtons.forEach(button => {
    if (button.textContent.includes('انتخاب پلن') || button.textContent.includes('شروع اشتراک')) {
      button.addEventListener('click', function(e) {
        e.preventDefault();

        const planName = this.closest('.card').querySelector('h3').textContent;

        const confirmed = confirm(`آیا مطمئن هستید که می‌خواهید پلن "${planName}" را انتخاب کنید؟`);

        if (confirmed) {
          alert(`پلن "${planName}" با موفقیت انتخاب شد. به صفحه پرداخت منتقل می‌شوید.`);
        }
      });
    }
  });
});