// Mock user subscription status - in real app this would come from server
const userSubscription = {
  isPremium: false, // Change to true to simulate premium user
  planType: 'basic', // 'basic', 'professional', 'gold'
  daysLeft: 0
};

// Function to check if user has access to specific channel
function hasChannelAccess(channelType) {
  if (!userSubscription.isPremium) return false;

  switch (channelType) {
    case 'forex':
      return ['professional', 'gold'].includes(userSubscription.planType);
    case 'crypto':
      return ['professional', 'gold'].includes(userSubscription.planType);
    case 'gold':
      return userSubscription.planType === 'gold';
    case 'stocks':
      return ['professional', 'gold'].includes(userSubscription.planType);
    default:
      return false;
  }
}

// Function to show channel access buttons or premium message
function updateChannelAccess() {
  const channels = [
    { type: 'forex', link: 'https://t.me/TraderProForex', name: 'کانال فارکس' },
    { type: 'crypto', link: 'https://t.me/TraderProCrypto', name: 'کانال کریپتو' },
    { type: 'gold', link: 'https://t.me/TraderProGold', name: 'کانال طلا' },
    { type: 'stocks', link: 'https://t.me/TraderProStocks', name: 'کانال سهام' }
  ];

  channels.forEach(channel => {
    const checkElement = document.getElementById(`premium-check-${channel.type}`);
    if (!checkElement) return;

    if (hasChannelAccess(channel.type)) {
      // User has access - show join button
      checkElement.innerHTML = `
        <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-lg p-4 mb-4">
          <div class="flex items-center justify-between">
            <div class="flex items-center space-x-3 space-x-reverse">
              <iconify-icon icon="solar:check-circle-bold" class="text-green-500 text-xl"></iconify-icon>
              <div>
                <h4 class="font-semibold text-green-800 dark:text-green-300">دسترسی فعال</h4>
                <p class="text-sm text-green-600 dark:text-green-400">شما به این کانال دسترسی دارید</p>
              </div>
            </div>
            <a href="${channel.link}" target="_blank" class="btn-primary text-sm px-4 py-2">
              <iconify-icon icon="solar:widget-2-bold" class="ml-1"></iconify-icon>
              ورود به کانال
            </a>
          </div>
        </div>
      `;
    } else {
      // User doesn't have access - show premium message
      const isPremiumRequired = channel.type === 'gold' ? 'طلایی' : 'پریمیوم';
      checkElement.innerHTML = `
        <div class="bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg p-4 mb-4">
          <div class="flex items-center space-x-3 space-x-reverse">
            <iconify-icon icon="solar:crown-bold" class="text-yellow-500 text-xl"></iconify-icon>
            <div>
              <h4 class="font-semibold text-yellow-800 dark:text-yellow-300">دسترسی ${isPremiumRequired} مورد نیاز</h4>
              <p class="text-sm text-yellow-700 dark:text-yellow-400">برای عضویت در ${channel.name} ابتدا اشتراک ${isPremiumRequired} تهیه کنید</p>
            </div>
          </div>
        </div>
        <a href="/subscription" class="btn-primary inline-block">تهیه اشتراک ${isPremiumRequired}</a>
      `;
    }
  });
}

// Function to simulate premium access (for demo)
function simulatePremiumAccess() {
  userSubscription.isPremium = true;
  userSubscription.planType = 'professional';
  userSubscription.daysLeft = 25;

  updateChannelAccess();

  // Show success message
  showNotification('دسترسی پریمیوم فعال شد! (شبیه‌سازی)', 'success');
}

// Function to simulate basic access (for demo)
function simulateBasicAccess() {
  userSubscription.isPremium = false;
  userSubscription.planType = 'basic';
  userSubscription.daysLeft = 0;

  updateChannelAccess();

  // Show info message
  showNotification('حالت کاربر عادی فعال شد! (شبیه‌سازی)', 'info');
}

// Notification function
function showNotification(message, type = 'info') {
  const alertDiv = document.createElement('div');
  alertDiv.className = `fixed top-4 left-1/2 transform -translate-x-1/2 z-50 px-6 py-4 rounded-lg shadow-lg transition-all duration-300 ${
    type === 'success' ? 'bg-green-500 text-white' :
    type === 'error' ? 'bg-red-500 text-white' :
    'bg-blue-500 text-white'
  }`;

  alertDiv.innerHTML = `
    <div class="flex items-center space-x-2 space-x-reverse">
      <iconify-icon icon="${
        type === 'success' ? 'solar:check-circle-bold' :
        type === 'error' ? 'solar:close-circle-bold' :
        'solar:info-circle-bold'
      }" class="text-xl"></iconify-icon>
      <span>${message}</span>
    </div>
  `;

  document.body.appendChild(alertDiv);

  setTimeout(() => {
    alertDiv.style.opacity = '0';
    alertDiv.style.transform = 'translate(-50%, -100%)';
    setTimeout(() => {
      if (document.body.contains(alertDiv)) {
        document.body.removeChild(alertDiv);
      }
    }, 300);
  }, 4000);
}

// Initialize when page loads
document.addEventListener('DOMContentLoaded', function() {
  updateChannelAccess();

  // Add demo buttons for testing (remove in production)
  const demoButtons = document.createElement('div');
  demoButtons.className = 'fixed bottom-4 left-4 space-x-2 space-x-reverse z-50';
  demoButtons.innerHTML = `
    <button onclick="simulatePremiumAccess()" class="bg-green-500 text-white px-3 py-1 rounded text-xs">
      Demo: Premium
    </button>
    <button onclick="simulateBasicAccess()" class="bg-gray-500 text-white px-3 py-1 rounded text-xs">
      Demo: Basic
    </button>
  `;
  document.body.appendChild(demoButtons);
});