class BannerSlider {
  constructor() {
    this.currentSlide = 0;
    this.totalSlides = 3;
    this.autoPlayInterval = 5000;
    this.autoPlayTimer = null;
    this.init();
  }

  init() {
    this.bindEvents();
    this.startAutoPlay();
    this.updateIndicators();
  }

  bindEvents() {
    const prevBtn = document.getElementById('prevBtn');
    const nextBtn = document.getElementById('nextBtn');
    const indicators = document.querySelectorAll('.slider-indicator');

    if (prevBtn) {
      prevBtn.addEventListener('click', () => this.prevSlide());
    }

    if (nextBtn) {
      nextBtn.addEventListener('click', () => this.nextSlide());
    }

    indicators.forEach((indicator, index) => {
      indicator.addEventListener('click', () => this.goToSlide(index));
    });

    const slider = document.getElementById('slider');
    if (slider) {
      slider.addEventListener('mouseenter', () => this.stopAutoPlay());
      slider.addEventListener('mouseleave', () => this.startAutoPlay());
    }

    document.addEventListener('keydown', (e) => {
      if (e.key === 'ArrowLeft') {
        this.nextSlide();
      } else if (e.key === 'ArrowRight') {
        this.prevSlide();
      }
    });
  }

  goToSlide(slideIndex) {
    this.currentSlide = slideIndex;
    this.updateSlider();
    this.updateIndicators();
  }

  nextSlide() {
    this.currentSlide = (this.currentSlide + 1) % this.totalSlides;
    this.updateSlider();
    this.updateIndicators();
  }

  prevSlide() {
    this.currentSlide = this.currentSlide === 0 ? this.totalSlides - 1 : this.currentSlide - 1;
    this.updateSlider();
    this.updateIndicators();
  }

  updateSlider() {
    const slider = document.getElementById('slider');
    if (slider) {
      const translateX = -this.currentSlide * 100;
      slider.style.transform = `translateX(${translateX}%)`;
    }
  }

  updateIndicators() {
    const indicators = document.querySelectorAll('.slider-indicator');
    indicators.forEach((indicator, index) => {
      if (index === this.currentSlide) {
        indicator.classList.add('active');
        indicator.classList.remove('bg-white', 'bg-opacity-50');
        indicator.classList.add('bg-white', 'bg-opacity-80');
      } else {
        indicator.classList.remove('active');
        indicator.classList.remove('bg-white', 'bg-opacity-80');
        indicator.classList.add('bg-white', 'bg-opacity-50');
      }
    });
  }

  startAutoPlay() {
    this.stopAutoPlay();
    this.autoPlayTimer = setInterval(() => {
      this.nextSlide();
    }, this.autoPlayInterval);
  }

  stopAutoPlay() {
    if (this.autoPlayTimer) {
      clearInterval(this.autoPlayTimer);
      this.autoPlayTimer = null;
    }
  }
}

document.addEventListener('DOMContentLoaded', () => {
  new BannerSlider();
});