const express = require('express');
const router = express.Router();

// Admin Login Page
router.get('/login', (req, res) => {
  res.render('admin/login', {
    title: 'ورود مدیریت',
    error: req.query.error
  });
});

// Admin Authentication
router.post('/auth', (req, res) => {
  const { username, password } = req.body;

  // Simple authentication - in production use proper password hashing
  if (username === 'admin' && password === 'admin123') {
    req.session.adminLoggedIn = true;
    res.redirect('/admin/dashboard');
  } else {
    res.redirect('/admin/login?error=1');
  }
});

// Admin Dashboard
router.get('/dashboard', (req, res) => {
  res.render('admin/dashboard', {
    title: 'داشبورد مدیریت',
    currentPage: 'dashboard'
  });
});

// Users Management
router.get('/users', (req, res) => {
  res.render('admin/users', {
    title: 'مدیریت کاربران',
    currentPage: 'users'
  });
});

// Content Management
router.get('/content', (req, res) => {
  res.render('admin/content', {
    title: 'مدیریت محتوا',
    currentPage: 'content'
  });
});

// Signals Management
router.get('/signals', (req, res) => {
  res.render('admin/signals', {
    title: 'مدیریت سیگنال‌ها',
    currentPage: 'signals'
  });
});

// Settings
router.get('/settings', (req, res) => {
  res.render('admin/settings', {
    title: 'تنظیمات',
    currentPage: 'settings'
  });
});

// Logout
router.post('/logout', (req, res) => {
  req.session.destroy();
  res.redirect('/admin/login');
});

module.exports = router;